﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using UnityEngine;
using NovelInterpreter.Instance.Drawer;

/// <summary>
/// メッセージウィンドウを描画するためのクラス
/// </summary>
public class MessageWindow : MonoBehaviour
{
	/// <summary>
	/// 描画したいテクスチャ
	/// </summary>
	public Texture2D texture = null;

	/// <summary>
	/// テクスチャ色
	/// これを変更しても動的に変わるわけじゃない
	/// </summary>
	public Color textureColor = new Color(1, 1, 1, 1);

	/// <summary>
	/// テクスチャ色
	/// 動的に色を変えたい場合はこちらを変更
	/// </summary>
	public Color TextureColor
	{
		get { return this.textureColor; }
		set
		{
			this.textureColor = value;
			this.window.textureColor = value;
		}
	}

	/// <summary>
	/// 背景色
	/// これを変更しても背景の色は変わらない
	/// </summary>
	public Color backgroundColor = new Color(1, 1, 1, 1);

	/// <summary>
	/// ウィンドウの背景色
	/// 動的に色を変えたい場合はこっちを使う
	/// </summary>
	public Color BackgroundColor
	{
		get { return this.backgroundColor; }
		set
		{
			this.backgroundColor = value;
			this.window.backColor = value;
		}
	}

	/// <summary>
	/// 前景色
	/// </summary>
	public Color foregroundColor = new Color(0, 0, 0, 0);

	/// <summary>
	/// ウィンドウの前景色
	/// 動的に色を変えたい場合はこっちを使う
	/// </summary>
	public Color ForegroundColor
	{
		get { return this.foregroundColor; }
		set
		{
			this.foregroundColor = value;
			this.window.frontColor = value;
		}
	}

	/// <summary>
	/// 描画する文字のスタイル
	/// </summary>
	public GUIStyle fontStyle = new GUIStyle();

	/// <summary>
	/// 描画したい文字
	/// </summary>
	public string drawText = "";

	/// <summary>
	/// 文字送りの速さ, 秒で指定
	/// </summary>
	public float escapementSpeed = 0f;

	/// <summary>
	/// 横幅の長さ, 0の時はテクスチャに依存
	/// これを変更しても反映されないので注意
	/// </summary>
	public int width = 0;

	/// <summary>
	/// 横幅の長さ, 0の時はテクスチャに依存
	/// 動的に長さを変える場合はこちらを使う
	/// </summary>
	public int Width
	{
		get { return this.width; }
		set 
		{ 
			this.width = value;
			this.window.width = value;
			this.text.style.fixedWidth = value;
		}
	}

	/// <summary>
	/// 縦幅の長さ, 0の時はテクスチャに依存
	/// これを変更しても反映されないので注意
	/// </summary>
	public int height = 0;

	/// <summary>
	/// 縦幅の長さ, 0の時はテクスチャに依存
	/// 動的に長さを変える場合はこちらを使う
	/// </summary>
	public int Height
	{
		get { return this.height; }
		set
		{
			this.height = value;
			this.window.height = value;
			this.text.style.fixedHeight = value;
		}
	}

	/// <summary>
	/// ウィンドウの描画クラス
	/// </summary>
	WindowDrawer window = null;

	/// <summary>
	/// 文字の描画クラス
	/// </summary>
	TextDrawer text = null;

	/// <summary>
	/// ウィンドウの生成
	/// </summary>
	void CreateWindow()
	{
		this.window = new WindowDrawer(texture, textureColor, backgroundColor, foregroundColor, width, height);
	}

	/// <summary>
	/// テキストの生成
	/// </summary>
	void CreateText()
	{
		fontStyle.fixedWidth = width;
		fontStyle.fixedHeight = height;
		this.text = new TextDrawer(fontStyle, drawText, escapementSpeed);
	}

	void Start()
	{
		CreateWindow();
		CreateText();
	}

	void OnGUI()
	{
		try
		{
			this.window.Draw(this.transform);
			this.text.Draw(this.transform);
		}
		catch (NullReferenceException)
		{
			Debug.LogError("生成に失敗してます");
			Application.Quit();
		}
	}
}
